//	GSOS_Icons.h

#ifndef _H_GSOS_Icons
#define _H_GSOS_Icons

#include "ByteMunger.h"

/*
Word   iconType       Bit 15 set to 1 = color icon, set to 0 = black & white
Word   iconSize       INTEGER; number of bytes in icon image
Word   iconHeight     INTEGER; height of icon in pixels
Word   iconWidth      INTEGER; width of icon in pixels
xBytes iconImage      iconSize bytes long, each row of pixels is 1 + (icon width -1)/2 bytes wide
xBytes iconMask       iconSize bytes long, each row of pixels is 1 + (icon width -1)/2 bytes wide 
*/

typedef struct {
	RboShort		type;		//	1 == color, 0 == b&w
	RboShort		num_bytes;
	RboShort		height;
	RboShort		width;
	char			icon[1];	//	variable length for image then mask
	//	mask follows
} GSOS_Icon;

/*
+000    iDataLen    Word    The length of this Icon Data record.  A 
                            value of zero in this field terminates the 
                            list of Icon Data records.
+002    iDataBoss   64 Bytes  The pathname of the 
                            application that owns this icon.  If this 
                            String has non-zero length, and the file 
                            this icon is associated with is a document 
                            (not an application, folder, device, or 
                            trash can), the Finder attempts to launch 
                            a file with this pathname when this icon 
                            is opened or printed.  This string should 
                            be empty for non-documents.  This is a 
                            full pathname, and most developers 
                            creating icons will wish to set this to 
                            the full pathname of the application on 
                            the shipping disk.
+066    iDataName   16 Bytes  A 16-byte String containing a 
                            file name.  Files on disk must match the 
                            specification of this string or this icon 
                            will not be displayed for the files.  The 
                            asterisk (*) serves as a wildcard 
                            character.  For example, the string *.ASM 
                            matches all filenames ending with the 
                            characters .ASM.
+082    iDatatype    Word   File type associated with this icon.  
                            Files on disk must have this file type for 
                            this icon to be displayed.  A file type of 
                            $0000 in this field matches any file type 
                            on disk.  As an example, an application 
                            icon would want to have the filename of 
                            the application in the iDataName field and 
                            the file type $00B3 (GS/OS Application) in 
                            this field.  Without the file type 
                            specification, the icon would show up for 
                            any file with the applications file name, 
                            including a folder on a hard disk in which 
                            the user has placed the application.
+084    iDataAux     Word   Auxiliary type associated with this icon.  
                            Similar to the file type field, a value of 
                            $0000 here matches any auxiliary type on 
                            disk.
+086    iDataBig     Icon   The normal size icon image data.
        iDataSmall   Icon   The small size icon image data.
*/
typedef struct {
	RboShort		data_length;	//	zero means no more entries
	char			pathAC[64];
	char			nameAC[16];
	RboShort		file_type;
	RboShort		aux_type;
	GSOS_Icon		big_icon;
	//	small icon follows
} GSOS_IconDataRec;

/*
+000    iBlkNext   Long     When loaded by the Finder, this is the 
                            handle to the next icon file (a linked 
                            list terminated by zero).  On disk, this 
                            field should be zero.
+004    iBlkID     Word     ID number of this type of icon file.  This 
                            field must be $0001 for the Finder to 
                            recognize the icon file.
+006    iBlkPath   Long     When loaded by the Finder, this is the 
                            handle to the pathname of this icon file.  
                            On disk, this field should be zero.
+010    iBlkName   16 Bytes A 16-byte String of the name of the icon 
                            file.
+026    iBlkIcons  IconData A list of Icon Data records.
*/

typedef struct Topic_struct				OTLN_TopicRec, *OTLN_TopicP, **OTLN_TopicH;


typedef struct GSOS_Icon_struct			GSOS_IconRec, *GSOS_IconRecP, **GSOS_IconRecH;

typedef struct GSOS_Icon_struct {
	GSOS_IconRecH		nextH;			//	handle to next
	RboShort			type_id;		//	should be $01
	Handle				nameH;			//	handle to name
	char				nameAC[16];
	GSOS_IconDataRec	icon_dataA[1];	//	variable length
} GSOS_IconRec;

typedef enum {
	GSOS_IconSize_NONE = -1, 

	GSOS_IconSize_SMALL, 
	GSOS_IconSize_LARGE, 
	
	GSOS_IconSize_NUMTYPES
} GSOS_IconSizeType;

#define	FOR_EACH_ICON_SIZE(_SIZE)	\
	for (_SIZE = GSOS_IconSize_SMALL; _SIZE <= GSOS_IconSize_LARGE; _SIZE = (GSOS_IconSizeType)(_SIZE + 1))

typedef enum {
	GSOS_Icon_NONE	= -1, 
	
	GSOS_Icon_IMAGE, 
	GSOS_Icon_MASK, 
	
	GSOS_IconType_NUMTYPES
} GSOS_IconType;

#define	FOR_EACH_ICON_TYPE(_TYPE)	\
	for (_TYPE = GSOS_Icon_IMAGE; _TYPE <= GSOS_Icon_MASK; _TYPE = (GSOS_IconType)(_TYPE + 1))

typedef struct GSOS_IconArrayRec_struct		GSOS_IconArrayRec, *GSOS_IconArrayP, **GSOS_IconArrayH;

typedef struct GSOS_IconArrayRec_struct {
	char				nameAC[32];
	ushort				auxType;
	Handle				iconH;
	GSOS_IconArrayH		next;
} GSOS_IconArrayRec;

typedef struct {
	ushort	sizeS;
	char	*dataP;
} IconDataAtom;

//	a "desc" includes image and mask
typedef	IconDataAtom	IconDataDesc[GSOS_IconType_NUMTYPES];

//	a "group" includes small and large atoms
typedef	IconDataDesc	IconDataGroup[GSOS_IconSize_NUMTYPES];

OSErr		GSOS_GetIndIconData(
	GSOS_IconRecH		iconRecH, 
	ushort				indexS, 
	GSOS_IconDataRec	**dataRecPP);

OSErr		GSOS_GetIndIconData(
	GSOS_IconDataRec	*dataRecP, 
	GSOS_IconSizeType	size, 
	GSOS_IconType		type, 
	ushort				*sizeS, 
	char				**dataPP);

class		CFilePro;
void		GSOS_AddIconFile(CFilePro *fileP);
Boolean		GSOS_HasCustomIcon(ushort fileType, ushort auxType, char *nameZ);

Handle		GSOS_GetCustomIcon(
	ushort				fileType, 
	ushort				auxType, 
	char				*nameZ, 
	GSOS_IconArrayH		**recHPP0 = NULL);
	
void		GSOS_PostDispose(void);

#endif